//*******************************************************************************************************/
//* FileName:		demoView.cpp
//*
//* Contents:		demo implementation of clPlot.
//*
//* Note:			Most of the stuff in this file is standard MFC implementation stuff not related to 
//*					the plot.
//*
//*					The implementation of the plot in the demo are done as following:
//*
//*					1.	OnInitialUpdate creates the plot and initialize it. It also activates a timer.
//*
//*					2.	OnTimer	adds data points to the plot every second.
//*
//*					3.	OnSize re-sizes the plot to fit the entire view as needed.
//*
//*					4.	OnEraseBkgnd is overrided to do nothing. This is needed for flicker free drawing.
//*
//* Author:			Jan Vidar Berger
//*******************************************************************************************************/

#include "stdafx.h"
#include "Demo.h"

#include "DemoDoc.h"
#include "DemoView.h"

#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern unsigned int global_chart;
static double abscisse;


/////////////////////////////////////////////////////////////////////////////
// CDemoView

IMPLEMENT_DYNCREATE(CDemoView, CView)

BEGIN_MESSAGE_MAP(CDemoView, CView)
	//{{AFX_MSG_MAP(CDemoView)
	ON_WM_TIMER()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_SELECT_TRACE1, OnSelectTrace1)
	ON_COMMAND(ID_SELECT_TRACE2, OnSelectTrace2)
	ON_COMMAND(ID_SELECT_TRACE3, OnSelectTrace3)
	ON_COMMAND(ID_START_STOP, OnSelectStartStop)
	ON_UPDATE_COMMAND_UI(ID_SELECT_TRACE1, OnUpdateSelectTrace1)
	ON_UPDATE_COMMAND_UI(ID_SELECT_TRACE2, OnUpdateSelectTrace2)
	ON_UPDATE_COMMAND_UI(ID_SELECT_TRACE3, OnUpdateSelectTrace3)
	ON_UPDATE_COMMAND_UI(ID_START_STOP, OnUpdateStartStop)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck2)
	ON_BN_CLICKED(IDC_CHECK3, OnCheck3)
	ON_BN_CLICKED(ID_SELECT_TRACE1, OnSelectTrace11)	//##
	ON_COMMAND(ID_TEST_T1, OnTestT1)
	//}}AFX_MSG_MAP
	// Standard printing commands
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoView construction/destruction

CDemoView::CDemoView()
{
	// TODO: add construction code here
canSize=FALSE;
}

CDemoView::~CDemoView()
{
}

BOOL CDemoView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	if( !CView::PreCreateWindow(cs) )
      return FALSE;
    // Create a window as wanted 
 //   cs.style = WS_MAXIMIZE;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CDemoView drawing

void CDemoView::OnDraw(CDC* pDC)
{
	CDemoDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CDemoView printing

/////////////////////////////////////////////////////////////////////////////
// CDemoView diagnostics

#ifdef _DEBUG
void CDemoView::AssertValid() const
{
	CView::AssertValid();
}

void CDemoView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CDemoDoc* CDemoView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDemoDoc)));
	return (CDemoDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDemoView message handlers

void CDemoView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	CRect Rect;
	GetClientRect(Rect);
	m_Plot.Create(WS_CHILD|WS_VISIBLE,Rect,this,12000);

	// Attributs de trac PS_SOLID, PS_DOT, PS_DASH

//	if (global_chart & 0x0001)													//##
		m_Plot.SetSerie(0, PS_SOLID, RGB(255,0,0), 0.0, 2000.0, "Pressure");
//	if (global_chart & 0x0002)
		m_Plot.SetSerie(1, PS_SOLID, RGB(0,0,255), 0.0, 2000.0, "Pressure");
//	if (global_chart & 0x0004)
		m_Plot.SetSerie(2, PS_DASH, RGB(0,0,0), 0.0, 2000.0, "Pressure");

//		m_Plot.SetSerie(3, PS_SOLID, RGB(255,255,0), 0.0, 2000.0, "Pressure");

//	m_Plot.SetLegend(0, PS_SOLID, RGB(255,0,0), "Temperature");
//	m_Plot.SetLegend(1, PS_DOT, RGB(0,255,0), "Pressure");
//	m_Plot.SetLegend(2, PS_DASH, RGB(0,0,255), "Pressure");
//	m_Plot.SetLegend(3, PS_SOLID, RGB(255,255,0), "Pressure");

	m_Plot.m_bAutoScrollX=TRUE;

	SetTimer(1,1000,NULL);
	canSize=TRUE;
}

void CDemoView::OnTimer(UINT nIDEvent) 
{
	static BOOL pros={FALSE};
	if(!pros){
		pros=TRUE;

		double y0, y1, y2;

		// trac oscillogramme sinusoidal
		abscisse += 0.25;

		y0 = sin((double)(abscisse)) * 700 + 1200;

		if (y0 < 900) y1 = 200;
		else y1 = 400;

		y2 = 100;

		{
//		double y =(double)(abs(rand())%2000);						//##
		if (global_chart & 0x0001)
			m_Plot.AddPoint(0,  CTime::GetCurrentTime(), y0);
		}
		{
//		double y =(double)(abs(rand())%2000);
		if (global_chart & 0x0002)
			m_Plot.AddPoint(1,  CTime::GetCurrentTime(), y1);
		}
		{
//		double y =(double)(abs(rand())%2000);
		if (global_chart & 0x0004)
			m_Plot.AddPoint(2,  CTime::GetCurrentTime(), y2);
		}
		{
		//double y =(double)(abs(rand())%2000);
//			double y=500.0;
//		m_Plot.AddPoint(3,  CTime::GetCurrentTime(), y);
		}
		Invalidate();
		pros=FALSE;
	}
	CView::OnTimer(nIDEvent);
}

void CDemoView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	if(canSize){
		CRect Rect;
		GetClientRect(Rect);
		m_Plot.MoveWindow(Rect);
	}
}

BOOL CDemoView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	
	return FALSE;
}


/////////////////////////////////////////////////////////////////////////////

// Fonctions de slection des traces  afficher

void CDemoView::OnUpdateSelectTrace1(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if ((global_chart & 1) == 0)	pCmdUI->SetCheck(FALSE);
	else							pCmdUI->SetCheck(TRUE);
}

void CDemoView::OnSelectTrace1() 
{
	// TODO: Add your command handler code here
	if ((global_chart & 1) == 0)	global_chart |= 0x01;
	else							global_chart &= 0xFE;
}

void CDemoView::OnUpdateSelectTrace2(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if ((global_chart & 2) == 0)	pCmdUI->SetCheck(FALSE);
	else							pCmdUI->SetCheck(TRUE);
	
}

void CDemoView::OnSelectTrace2() 
{
	// TODO: Add your command handler code here
	if ((global_chart & 2) == 0)	global_chart |= 0x02;
	else							global_chart &= 0xFD;
}

void CDemoView::OnUpdateSelectTrace3(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if ((global_chart & 4) == 0)	pCmdUI->SetCheck(FALSE);
	else							pCmdUI->SetCheck(TRUE);
	
}

void CDemoView::OnSelectTrace3() 
{
	// TODO: Add your command handler code here
	if ((global_chart & 4) == 0)	global_chart |= 0x04;
	else							global_chart &= 0xFB;
}

void CDemoView::OnUpdateStartStop(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if ((global_chart & 8) != 0)	pCmdUI->SetCheck(FALSE);
	else							pCmdUI->SetCheck(TRUE);
	
}

void CDemoView::OnSelectStartStop() 
{
	// TODO: Add your command handler code here
	if ((global_chart & 8) == 0)	global_chart |= 0x08;
	else							global_chart &= 0xF7;
}


void CDemoView::OnCheck3() 
{
	// TODO: Add your control notification handler code here

		global_chart = 7;
  
}


void CDemoView::OnCheck2() 
{
	// TODO: Add your control notification handler code here

		global_chart = 7;
  
}




void CDemoView::OnCheck1() 
{
	// TODO: Add your control notification handler code here
	global_chart = 5;
}

void CDemoView::OnSelectTrace11() 
{
	// TODO: Add your control notification handler code here
	global_chart = 3;
	
}

void CDemoView::OnTestT1() 
{
	// TODO: Add your command handler code here
	global_chart = 9;
	
}



/*
void CDemoView::OnButton7() 
{
	// TODO: Add your control notification handler code here
	global_chart = 11;
	
}
*/